package fr.upmc.tep.algos;

import java.util.ArrayList;
import java.util.Comparator;

import fr.upmc.tep.MyClass;
import fr.upmc.tep.MyJVM;
import fr.upmc.tep.MyMethod;
import fr.upmc.tep.MyRun;

public abstract class Algorithme implements Comparator<MyMethod> {

	public MyJVM jvm;

	public Algorithme() {
		super();
		this.jvm = null;
	}

	/**
	 * Compare le nom, la nb de param et le type des param (doivent etre
	 * compatible)
	 */
	public int compare(MyMethod m1, MyMethod m2) {
		if (!m1.name.equals(m2.name)) {
			return 1;
		}
		if (!(m1.myParameters.size() == m2.myParameters.size())) {
			return 2;
		}
		for (int i = 0; i < m1.myParameters.size(); i++) {
			MyClass param1 = m1.myParameters.get(i);
			MyClass param2 = m2.myParameters.get(i);
			if (!param1.equals(param2) && !param2.estSousType(param1)) {
				return 3;
			}
		}
		return 0;
	}

	public final ArrayList<MyMethod> getPossibles(MyMethod call) {
		ArrayList<MyMethod> possibles = new ArrayList<MyMethod>();
		ArrayList<MyClass> allClassParents = call.myClass.getAllClassParents();
		for (MyClass myClass : allClassParents) {
			for (MyMethod myMethod : myClass.myMethods) {
				if (compare(myMethod, call) == 0) {
					possibles.add(myMethod);
				}
			}
		}

		return possibles;
	}

	public final MyMethod staticMode(MyJVM jvm, MyRun run) {
		setJVM(jvm);
		return runAlgoStatic(getMethodInStaticMode(run));
	}

	public final MyMethod dynamicMode(MyJVM jvm, MyRun run, MyMethod choixStatic) {
		setJVM(jvm);
		return runAlgoDynamic(getMethodInDynamicMode(run), choixStatic);
	}

	private final void setJVM(MyJVM jvm) {
		this.jvm = jvm;
	}

	public MyMethod runAlgoDynamic(MyMethod call, MyMethod choixStatic) {
		MyMethod choisi;

		if (choixStatic == null) {
			System.out
					.println("\tPas de choix en static donc pas de choix en dynamique !!");
			return null;
		}

		ArrayList<MyClass> classParents = call.myClass.getAllClassParents();
		for (MyClass myClass : classParents) {
			for (MyMethod myMethod : myClass.myMethods) {
				if (myMethod.equalsMethod(choixStatic)) {
					choisi = myMethod;
					System.out.println("\tCall :"
							+ call.toStringSansReturnType());
					System.out.println("\tChoisi : [" + choisi + "]");
					return choisi;
				}
			}
		}
		return null;
	}

	public MyMethod runAlgoStatic(MyMethod call) {
		ArrayList<MyMethod> possibles = getPossibles(call);

		ArrayList<MyMethod> choisis = new ArrayList<MyMethod>();
		ArrayList<Integer> valeurs = new ArrayList<Integer>();

		// on calcule la valeur de chacune
		for (int i = 0; i < possibles.size(); i++) {
			valeurs.add(value(call, possibles.get(i)));
			// System.out.print(call);
			// System.out.print(" " + possibles.get(i));
			// System.out.println(" " + valueStatic(call, possibles.get(i)));
		}

		// On choisi la val max
		Integer valMax = -1;
		for (Integer valeur : valeurs) {
			if (valMax < valeur) {
				valMax = valeur;
			}
		}

		// On met les methodes avec la valMax dans choisi
		for (int i = 0; i < valeurs.size(); i++) {
			if (valeurs.get(i).intValue() == valMax) {
				choisis.add(possibles.get(i));
			}
		}

		if (choisis.size() > 1) {
			// on degage les override :

			// Methodes dans lequel on va supprimer les oveerides
			ArrayList<MyMethod> methods = new ArrayList<MyMethod>(choisis);
			// Pour tte les methodes choisis,
			for (MyMethod myMethod : choisis) {

				// on va chercher les mthodes qui sont gales
				ArrayList<MyMethod> methodsOverride = new ArrayList<MyMethod>(
						methods);
				for (MyMethod myMethod2 : methods) {
					// if (myMethod==myMethod2) {
					// methodsOverride.remove(myMethod2);
					// continue;
					// }
					if (!myMethod2.equalsMethod(myMethod)) {
						methodsOverride.remove(myMethod2);
					}
				}

				// On recherhce la mthode qui est la plus proche de call au
				// niveua
				// de la profondeur
				Integer[] prof = new Integer[methodsOverride.size()];
				int indexMinProf = -1;
				for (int i = 0; i < methodsOverride.size(); i++) {
					prof[i] = call.myClass
							.getProfondeur(methodsOverride.get(i).myClass);
				}
				for (int i = 0; i < methodsOverride.size(); i++) {
					if (indexMinProf > -1 && prof[i] < prof[indexMinProf]) {
						indexMinProf = i;
					} else {
						indexMinProf = 0;
					}
				}

				// On jartte les methodes qui ne sont pas la plus petite dans la
				// liste des methodes finales
				for (int i = 0; i < methodsOverride.size(); i++) {
					if (i != indexMinProf) {
						methods.remove(methodsOverride.get(i));
					}
				}
			}
			choisis = methods;
		}
		System.out.println("\tCall : " + call.toStringSansReturnType());
		System.out.println("\tPossibles : " + possibles);
		// System.out.println("\tChoisi (val:" + valMax + "):" + choisis);
		if (choisis.size() > 1 || choisis.size() < 1) {
			System.out.println("\tChoisis : " + choisis);
			System.out.println("\tImpossible de choisir !!!");
			return null;
		} else if (choisis.size() > 0) {
			System.out.println("\tChoisi : " + choisis);
			return choisis.get(0);
		} // else
		System.out.println("\tChoisi : " + choisis);
		return null;
	}

	protected abstract MyMethod getMethodInStaticMode(MyRun run);

	protected abstract MyMethod getMethodInDynamicMode(MyRun run);

	protected abstract Integer value(MyMethod call, MyMethod methode);

}
