package fr.upmc.tep;

import fr.upmc.tep.algos.*;

public class SimulAlgoResolutionJVM {

	public static String file = "tests/test_dtd.xml";

	public static boolean TESTMODE = false;

	public enum Algo {
		JAVA_1_2, JAVA_1_5, JAVA_EXAM, ALL
	}

	public static Algo algo = Algo.ALL;

	public static final String messageProgramme = "SimulAlgoResolutionJVM\n"
			+ "by Philippe DUL and Eric MASLIAH\n\n"
			+ "Usage : SimulAlgoResolutionJVM file [algo]\n"
			+ "with algo = 1.2 | 1.5 | exam | all (default)";

	public static void main(String args[]) {
		// Initialisation des variables

		if (!TESTMODE) {
			if (args.length == 0 || args.length > 2) {
				System.out.println(messageProgramme);
				return;
			}

			// Lecture du fichier
			file = args[0];
		}

		if (args.length > 1) {
			String algoString = args[1];
			if (algoString.equals("1.2")) {
				algo = Algo.JAVA_1_2;
			} else if (algoString.equals("1.5")) {
				algo = Algo.JAVA_1_5;
			} else if (algoString.equals("exam")) {
				algo = Algo.JAVA_EXAM;
			} else if (algoString.equals("all")) {
				algo = Algo.ALL;
			} else {
				System.out.println(messageProgramme);
				return;
			}
		}

		lectureFile(file);
	}

	private static void lectureFile(String string) {
		System.out.println("### Fichier " + string + "\n");
		MyJVM jvm = (new ParsageXML(string)).parse();
		System.out.println(jvm.toString());

		MyJDK jdk = new MyJDK(jvm);
		if (algo == Algo.ALL) {
			jdk.addAlgo(new Algo_Java_1_2());
			jdk.addAlgo(new Algo_Java_1_5());
			jdk.addAlgo(new Algo_Java_Exam());
		} else if (algo == Algo.JAVA_1_2) {
			jdk.addAlgo(new Algo_Java_1_2());
		} else if (algo == Algo.JAVA_1_5) {
			jdk.addAlgo(new Algo_Java_1_5());
		} else if (algo == Algo.JAVA_EXAM) {
			jdk.addAlgo(new Algo_Java_Exam());
		}
		jdk.run();
		System.out.println("### Fin Fichier " + string);
	}

}
