package fr.upmc.tep;

import java.io.IOException;

import org.xml.sax.*;
import org.xml.sax.helpers.XMLReaderFactory;

import fr.upmc.tep.exceptions.MyClassNotFoundException;

public class ParsageXML implements ContentHandler {

	public String filename;

	private MyJVM myJVM;

	private enum ModeParsage {
		MODE_READCLASSES, MODE_LIAISON
	}

	private ModeParsage modeParsage;

	private enum ModeType {
		CLASSES, RUNS
	}

	private ModeType modeType;

	private MyClass currentClass;
	private MyMethod currentMethod;
	private MyRun currentRun;

	public ParsageXML(String filename) {
		this.filename = filename;
		this.myJVM = new MyJVM();
	}

	public MyJVM parse() {
		XMLReader saxReader;
		try {
			saxReader = XMLReaderFactory.createXMLReader();
			// .createXMLReader("org.apache.xerces.parsers.SAXParser");
			saxReader.setContentHandler(this);

			modeParsage = ModeParsage.MODE_READCLASSES;
			saxReader.parse(filename);

			modeParsage = ModeParsage.MODE_LIAISON;
			saxReader.parse(filename);

		} catch (SAXException e) {
			System.out.println("SAXException : " + e.getMessage());
			System.exit(1);
		} catch (IOException e) {
			System.out.println("IOException : " + e.getMessage());
			System.exit(1);
		}
		return myJVM;
	}

	public void startElement(String uri, String localName, String name,
			Attributes atts) throws SAXException {
		try {

			if ("classes".equals(localName)) {
				modeType = ModeType.CLASSES;

			} else if ("runs".equals(localName)) {
				modeType = ModeType.RUNS;
			}

			if (modeType == ModeType.CLASSES) {

				if (modeParsage == ModeParsage.MODE_READCLASSES) {

					if ("class".equals(localName)) {
						MyClass myClass = new MyClass(atts.getValue("name"), false);
						myJVM.addClass(myClass);
					}
					else if ("interface".equals(localName)) {
						MyClass myClass = new MyClass(atts.getValue("name"), true);
						myJVM.addClass(myClass);
					}

				} else if (modeParsage == ModeParsage.MODE_LIAISON) {

					if ("class".equals(localName)) {
						currentClass = myJVM.getMyClass(atts.getValue("name"));
						
					} else if ("interface".equals(localName)) {
						currentClass = myJVM.getMyClass(atts.getValue("name"));

					} else if ("extend".equals(localName)) {
						currentClass.addMyExtends(myJVM.getMyClass(atts
								.getValue("name")));

					} else if ("implement".equals(localName)) {
						currentClass.addMyImplements(myJVM.getMyClass(atts
								.getValue("name")));

					} else if ("method".equals(localName)) {
						currentMethod = new MyMethod(atts.getValue("name"),
								currentClass);
						currentClass.addMyMethod(currentMethod);

					} else if ("parameter".equals(localName)) {
						currentMethod.addMyParameter(myJVM.getMyClass(atts
								.getValue("type")));

					} else if ("return".equals(localName)) {
						currentMethod.setReturnType(myJVM.getMyClass(atts
								.getValue("type")));

					}
				}
			} else if (modeType == ModeType.RUNS
					&& modeParsage == ModeParsage.MODE_LIAISON) {

				if ("object".equals(localName)) {
					currentRun = new MyRun(myJVM.getMyClass(atts
							.getValue("typeAffiche")), myJVM.getMyClass(atts
							.getValue("typeReel")));
					myJVM.addRun(currentRun);
				} else if ("method".equals(localName)) {
					currentRun.setMethodName(atts.getValue("name"));
				} else if ("parameter".equals(localName)) {
					currentRun.addMyParameter(myJVM.getMyClass(atts
							.getValue("typeAffiche")), myJVM.getMyClass(atts
							.getValue("typeReel")));
				}
			}

		} catch (MyClassNotFoundException e) {
			System.out.println("MyClassNotFoundException : " + e.getMessage());
			System.exit(2);
		}
	}

	public void endElement(String uri, String localName, String name)
			throws SAXException {

	}

	public void characters(char[] ch, int start, int length)
			throws SAXException {

	}

	public void endDocument() throws SAXException {

	}

	public void endPrefixMapping(String prefix) throws SAXException {

	}

	public void ignorableWhitespace(char[] ch, int start, int length)
			throws SAXException {

	}

	public void processingInstruction(String target, String data)
			throws SAXException {

	}

	public void setDocumentLocator(Locator locator) {

	}

	public void skippedEntity(String name) throws SAXException {

	}

	public void startDocument() throws SAXException {

	}

	public void startPrefixMapping(String prefix, String uri)
			throws SAXException {

	}
}
