package fr.upmc.tep;

import java.util.ArrayList;

public class MyMethod {

	public String name;
	
	public ArrayList<MyClass> myParameters;
	
	public MyClass myClass;
	
	public void setMyParameters(ArrayList<MyClass> myParameters) {
		this.myParameters = myParameters;
	}

	public MyClass returnType;
	
	private MyMethod() {
		myParameters=new ArrayList<MyClass>();
		name="(noname)";
		returnType=null;
		myClass=null;
	}

	public MyMethod(String name, MyClass myClass) {
		this();
		this.name = name;
		this.myClass = myClass;
	}
	
	public void addMyParameter(MyClass myParameter) {
		myParameters.add(myParameter);
	}
	
	public void setReturnType(MyClass returnType) {
		this.returnType = returnType;
	}

	public String toString() {
		String res=(returnType==null?"void":returnType.name);
		res+=toStringSansReturnType();
		return res;
	}
	
	public String toStringSansReturnType() {
		String res=" "+myClass.name+"."+name+"(";
		int i=0;
		for (MyClass value : myParameters) {
			res+=value.name+(i++>=myParameters.size()-1?"":", ");
		}
		res+=")";
		return res;
	}
	
	public boolean equalsMethod(MyMethod m2) {
		if (!name.equals(m2.name)) {
			return false;
		}
		
		if (myParameters.size()!=m2.myParameters.size()) {
			return false;
		}
		
		for (int i = 0; i < myParameters.size(); i++) {
			if (!(myParameters.get(i).equals(m2.myParameters.get(i)))) {
				return false;
			}
		}
		
		return true;
	}
	
}
