package fr.upmc.tep;

import java.util.ArrayList;
import java.util.HashMap;

import fr.upmc.tep.exceptions.MyClassNotFoundException;

public class MyJVM {
	
	public HashMap<String, MyClass> classes;
	
	public ArrayList<MyRun> runs;
	
	public MyJVM() {
		classes=new HashMap<String, MyClass>();
		runs=new ArrayList<MyRun>();
	}
	
	public void addClass(MyClass myClass) {
		classes.put(myClass.name, myClass);
	}
	
	public void addRun(MyRun myRun) {
		runs.add(myRun);
	}
	
	public MyClass getMyClass(String name) throws MyClassNotFoundException {
		if (classes.get(name)!=null) {
			return classes.get(name);
		} else {
			throw new MyClassNotFoundException(name);
		}
	}
	
	@Override
	public String toString() {
		String res="Classes :\n";
		for (MyClass value : classes.values()) {
			res+=value.toString()+"\n";
		}
		res+="\nRuns :\n";
		for (MyRun value : runs) {
			res+=value.toString()+"\n";
		}
		return res;
	}

}
