package fr.upmc.tep;

import java.util.ArrayList;

import fr.upmc.tep.algos.Algorithme;

public class MyJDK {
	
	public MyJVM jvm;
	
	public ArrayList<Algorithme> algos;
	
	public MyJDK(MyJVM jvm){
		this.jvm=jvm;
		algos = new ArrayList<Algorithme>();
		
	}
	
	public void addAlgo(Algorithme algo) {
		algos.add(algo);
	}
	
	public void run() {
		System.out.println("########### TESTS ########### ");
		for (MyRun run : jvm.runs) {
			System.out.println("\nRUN "+run.toString().toUpperCase()+"\n");
			for(Algorithme algo : algos) {
				System.out.println("ALGO "+algo.getClass().getName().toUpperCase()+"");
				System.out.println("staticMode :");
				MyMethod choixStatic = algo.staticMode(jvm, run);
				System.out.println("dynamicMode :");
				algo.dynamicMode(jvm, run, choixStatic);
				System.out.println("");
			}
			//System.out.println("");
		}
	}
}
