package fr.upmc.tep;

import java.util.ArrayList;

public class MyClass {

	public String name;

	public ArrayList<MyClass> myExtends;

	public ArrayList<MyClass> myImplements;

	public ArrayList<MyMethod> myMethods;

	boolean isInterface;

	private MyClass() {
		myExtends = new ArrayList<MyClass>();
		myImplements = new ArrayList<MyClass>();
		myMethods = new ArrayList<MyMethod>();
		name = "(noname)";
		isInterface = false;
	}

	public MyClass(String name, boolean isInterface) {
		this();
		this.name = name;
		this.isInterface = isInterface;
	}

	public void addMyExtends(MyClass myExtends) {
		this.myExtends.add(myExtends);
	}

	public void addMyMethod(MyMethod myMethod) {
		this.myMethods.add(myMethod);
	}

	public void addMyImplements(MyClass myImplements) {
		this.myImplements.add(myImplements);
	}

	public String toString() {
		String res = "";
		res += isInterface ? "interface " : "class ";
		res += name + " ";
		res += "extends [ ";
		for (MyClass value : myExtends) {
			res += value.name + "; ";
		}
		res += "] ";
		if (!isInterface) {
			res += "implements [ ";
			for (MyClass value : myImplements) {
				res += value.name + "; ";
			}
			res += "]\n\tmethods [ \n";
			for (MyMethod value : myMethods) {
				res += "\t\t" + value.toString() + "\n";
			}
			res += "\t]";
		}
		return res;
	}

	/**
	 * Calcul la profondeur de la class this par rapport a la classe classe
	 * @param classe
	 * @return la profondeur ou Integer.MAX_VALUE si this n'est pas sous class
	 *         de classe
	 */
	public int getProfondeur(MyClass classe) {
		int profondeur = Integer.MAX_VALUE;
		if (this.equals(classe)) {
			return 0;
		} // else
		for (MyClass myExtend : myExtends) {
			int resPro = myExtend.getProfondeur(classe);
			if (profondeur > resPro) {
				profondeur = resPro + 1;
			}
		}
		for (MyClass myImplement : myImplements) {
			int resPro = myImplement.getProfondeur(classe);
			if (profondeur > resPro) {
				profondeur = resPro + 1;
			}
		}
		
		return profondeur;
	}

	public boolean estSousType(MyClass param2) {
		int prof=getProfondeur(param2);
		if (prof != Integer.MAX_VALUE) {
			return true;
		} // else
		return false;
	}

	/**
	 * Renvoie tout les classes parents de la classe courante dont elle meme
	 * dans l'ordre (moi, pere, grand pere...)
	 * @return
	 */
	public final ArrayList<MyClass> getAllClassParents() {
		ArrayList<MyClass> allClassParents = new ArrayList<MyClass>();
		MyClass classCur;
		classCur = this;
		while (classCur != null) {
			allClassParents.add(classCur);
			if (classCur.myExtends.size() > 0) {
				classCur = classCur.myExtends.get(0);
			} else {
				classCur = null;
			}
		}
		return allClassParents;
	}
}
